/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger a = LogManager.getLogger();

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u26038 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u26039 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260314 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260315 = optionParser.nonOptions();
        try {
            Object \u260337;
            Object \u260335;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26039)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            j.h();
            uj.a();
            uj.c();
            v.l();
            Path \u260316 = Paths.get("server.properties", new String[0]);
            yf \u260317 = new yf(\u260316);
            \u260317.b();
            Path \u260318 = Paths.get("eula.txt", new String[0]);
            uo \u260319 = new uo(\u260318);
            if (optionSet.has((OptionSpec)\u26033)) {
                a.info("Initialized '{}' and '{}'", (Object)\u260316.toAbsolutePath(), (Object)\u260318.toAbsolutePath());
                return;
            }
            if (!\u260319.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u260320 = new File((String)optionSet.valueOf((OptionSpec)\u260311));
            YggdrasilAuthenticationService \u260321 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260322 = \u260321.createMinecraftSessionService();
            GameProfileRepository \u260323 = \u260321.createProfileRepository();
            abl \u260324 = new abl(\u260323, new File(\u260320, MinecraftServer.b.getName()));
            String \u260325 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260312)).orElse(\u260317.a().n);
            dae \u260326 = dae.a(\u260320.toPath());
            dae.a \u260327 = \u260326.c(\u260325);
            MinecraftServer.a(\u260327);
            bpn \u260328 = \u260327.e();
            boolean \u260329 = optionSet.has((OptionSpec)\u26038);
            if (\u260329) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            aar<aap> \u260330 = new aar<aap>(aap::new, new aau(), new aao(\u260327.a(dac.g).toFile(), aas.c));
            bpn \u260331 = MinecraftServer.a(\u260330, \u260328 == null ? bpn.a : \u260328, \u260329);
            CompletableFuture<uw> \u260332 = uw.a(\u260330.f(), da.a.b, \u260317.a().G, v.f(), Runnable::run);
            try {
                uw uw2 = \u260332.get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u260330.close();
                return;
            }
            uw2.i();
            gm.a a2 = gm.b();
            ue<lu> \u260333 = ue.a(lp.a, uw2.h(), a2);
            dal \u260334 = \u260327.a(\u260333, \u260331);
            if (\u260334 == null) {
                if (optionSet.has((OptionSpec)\u26034)) {
                    \u260335 = MinecraftServer.c;
                    \u260336 = cix.b;
                } else {
                    \u260337 = \u260317.a();
                    \u260335 = new bqe(((ye)\u260337).n, ((ye)\u260337).m, ((ye)\u260337).y, ((ye)\u260337).l, false, new bpx(), \u260331);
                    \u260336 = optionSet.has((OptionSpec)\u26035) ? ((ye)\u260337).U.k() : ((ye)\u260337).U;
                }
                \u260334 = new daj((bqe)\u260335, (cix)\u260336, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u26036)) {
                Main.a(\u260327, aep.a(), optionSet.has((OptionSpec)\u26037), () -> true, \u260334.z().g());
            }
            \u260327.a(a2, \u260334);
            \u260335 = \u260334;
            Object \u260336 = MinecraftServer.a(arg_0 -> Main.a(a2, \u260327, \u260330, uw2, (dal)\u260335, \u260317, \u260322, \u260323, \u260324, optionSet, (OptionSpec)\u260310, (OptionSpec)\u260313, (OptionSpec)\u26034, (OptionSpec)\u260314, (OptionSpec)\u26032, (OptionSpec)\u260315, arg_0));
            \u260337 = new Thread("Server Shutdown Thread", (yd)\u260336){
                final /* synthetic */ yd a;
                {
                    this.a = yd2;
                    super(string);
                }

                @Override
                public void run() {
                    this.a.a(true);
                }
            };
            ((Thread)\u260337).setUncaughtExceptionHandler(new m(a));
            Runtime.getRuntime().addShutdownHook((Thread)\u260337);
        }
        catch (Exception exception) {
            a.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void a(dae.a a2, DataFixer dataFixer, boolean bl2, BooleanSupplier booleanSupplier2, ImmutableSet<ug<bqb>> immutableSet) {
        a.info("Forcing world upgrade!");
        amu amu2 = new amu(a2, dataFixer, immutableSet, bl2);
        mr \u26032 = null;
        while (!amu2.b()) {
            BooleanSupplier booleanSupplier2;
            mr mr2 = amu2.h();
            if (\u26032 != mr2) {
                \u26032 = mr2;
                a.info(amu2.h().getString());
            }
            if ((\u2603 = amu2.e()) > 0) {
                int n2 = amu2.f() + amu2.g();
                a.info("{}% completed ({} / {} chunks)...", (Object)aec.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                amu2.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ yd a(gm.a a2, dae.a a3, aar aar2, uw uw2, dal dal2, yf yf2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, abl abl2, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        yd yd2 = new yd(thread, a2, a3, aar2, uw2, dal2, yf2, aep.a(), minecraftSessionService, gameProfileRepository, abl2, zo::new);
        yd2.d((String)optionSet.valueOf(optionSpec));
        yd2.a((Integer)optionSet.valueOf(optionSpec2));
        yd2.c(optionSet.has(optionSpec3));
        yd2.b((String)optionSet.valueOf(optionSpec4));
        boolean bl2 = \u2603 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u2603 && !GraphicsEnvironment.isHeadless()) {
            yd2.bb();
        }
        return yd2;
    }
}

